#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timers 4 and 5 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  OpenTimer45                                    *
*    Description:    This routine configures the timer control regis*
*                    ter and timer period register.                 *
*    Parameters:     config: bit definitions to configure Timer4    *
*                    and timer5 period to timer period register     *
*    Return Value:   None                                           *
********************************************************************/

void OpenTimer45(unsigned int  config,unsigned long period)
{
    TMR4 = 0;               /* Reset Timer4 to 0x0000 */
    TMR5 = 0;               /* Reset Timer5 to 0x0000 */
    PR4 = period;           /* assigning Period to Timer period register */
    PR5 = period>>16;       /* Period to PR4 and PR5 Register */
    T4CON = config;         /* configure timer control reg */
    T4CONbits.T32 = 1;
}

#endif 
